$LogFileLocation = "C:\Windows\ccm\Logs"
$LogFileNamePostAction = "WaaS_PostActions.log"
$LogFileNameOSUninstall = "WaaS_OSUninstall.log"
$LogFile = "$LogFileLocation\$LogFileNamePostAction"
$RegistryPath = "HKLM:SOFTWARE\WaaS"
$CurrentBuild = Get-ItemPropertyValue "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion" 'CurrentBuild' -ErrorAction SilentlyContinue
$WaaSParentKeysPath = 'HKLM:\SOFTWARE\WaaS'
$WaaSParentKeys = Get-Item $WaaSParentKeysPath
$WaaSParentBuildNumber = $WaaSParentKeys.GetValue('LastOSUpgradeTo')
$WaaSKeyCurrent = get-item "$WaaSParentKeysPath\$WaaSParentBuildNumber"
$WaaSStage = $WaaSKeyCurrent.GetValue('WaaS_Stage')

$legalnoticecaption = "Windows 11 $CurrentBuild Upgrade Complete"
$legalnoticetext = "You can now log back into your Machine."

#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = $env:computername,
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }
CMTraceLog -Message  "---Starting LegalNotice-UpgradeComplete Script---" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
CMTraceLog -Message  "  WaaS_Stage: $WaaSStage" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
if ($WaaSStage -eq "Deployment_Success")
    {   
    CMTraceLog -Message  " Updating Legal Text because Deployment Successful" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $legalnoticecaption
    Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $legalnoticetext
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    CMTraceLog -Message  "Updated Values: legalnoticecaption & legalnoticetext" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    #Unregister-ScheduledTask -TaskName SetLegalNoticeText-OSUpgradeComplete -Confirm:$false
    #CMTraceLog -Message  "Removed Scheduled Task SetLegalNoticeText-OSUpgradeComplete" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    
    }
else
    {
    CMTraceLog -Message  "  Doing Nothing, Deployment NOT Successful" -Type 1 -LogFile $LogFile -Component LegalText-IPUFAIL
    }

CMTraceLog -Message  "---Exiting LegalNotice-UpgradeComplete Script---" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess